clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');
linea=2;
%% Physical parameters
Rg=298.053; %Costante dell'aria (J/kg/K)
Temp=293;                  %Temperature (K)
% Calcolo della viscosit dinamica dell'aria in funzione della temperatura
% Costanti di Sutherland per l'aria
mu0 = 1.716e-5;    % Viscosit a 273.15 K (Pas)
T0 = 273.15;       % Temperatura di riferimento (K)
S = 110.4;         % Costante di Sutherland (K)
% Equazione di Sutherland
mu = mu0 * (Temp / T0)^(3/2) * (T0 + S) / (Temp + S);
pa=101325;
ps=3e5;                 %Supply pressure absolute (Pa)
rho=pa/(Rg*Temp);
dt=1e-7;                %Time Step (s)
cG=60000/rho;
%Definizione numero elementini nelle due direzioni
M=40; %nodi incogniti -2 direzione radiale
N=40;%nodi incogniti direzione circonferenziale
%Geometrical parameters
R2 =31.5e-3 ;  % outer radius (m)
R1 =2*R2/(M-1); % inner radius (m)

dr=(R2-R1)/(M-1);
dtheta=(2*pi)/(N-1);
nR =linspace(R1,R2,M); %Vettore dei raggi
nT =linspace(0,2*pi-dtheta,N);%Vettore degli angoli
nT=[nT(end), nT, nT(1)];

permeability=1.25*1e-15; %permeabilit (m^2)
L=6e-3;     %spessore strato poroso (m)
omega=0;
[Theta,R] = meshgrid(nT,nR) ; %crea le coordinate di tutti i punti %nR lo replica su ogni riga %nT su ogni colonna
% Convert grid to cartesian coordintes
Y =- R.*cos(Theta); 
X= R.*sin(Theta);
%Variable Initialization
Pin=pa;
Pold=ones(M,N+2)*Pin; 
Gi_new=ones(M,N+2)*Pin; 
GN=ones(M,N+2)*Pin; 
GS=ones(M,N+2)*Pin; 
gO=ones(M,N+2)*Pin; 
gE=ones(M,N+2)*Pin; 
Gout=ones(M,N+2)*Pin; 


Pnew=Pold;
pc0=Pin;
H0=14; %13 10  7

        Time=[];
        Fpt=[];
        Fet=[];       
        Gint=[];
        Goutt=[];
        Err_F=[];
        Err_G=[];
        Err_P=[];
        H0t=[];
        H0_dott=[];
        rms_X=[];

   tic  
   
    h0c=H0*1e-6;
    h0c_dot=0;
    h0=ones(size(Pold))*h0c;
    h0_dot=zeros(size(h0));
    err_P=10;
    err_G=10;
    err_F=10;
    no_punti=20000;


    iter=0;
    contatore=0;
    t=0;
    toll_F=1e-5;
    toll_G=1e-4;
    
    F1=0;

% Definizione del volume aggiuntivo rappresentativo delle porosit chiuse
% D = 2 * R2;  % Diametro del pattino
% V_extra = (pi * D^2 / 4) * (5e-6); % Volume aggiuntivo costante  con h 5, 50 o 100 micron
h_extra=1e-6;   %0.1


   while abs(err_G)>toll_G || abs(err_F)>toll_F
    iter=iter+1;
    t=t+dt;
    contatore=contatore+1;
    F0=F1;
    Pold=Pnew;
    
    jj=[2:N+1];   ii=[2:M-1]; %Nodi interni
    %Nodi interni
    %Calcolo portata in ingresso nodi
    Gi_new(ii,jj)=((ps^2-Pold(ii,jj).^2).*permeability.*R(ii,jj)*dr*dtheta)/(2*mu*Rg*Temp*L);
    %Calcolo portata radiale
    GN(ii,jj)=-(Pold(ii-1,jj).*h0(ii-1,jj).^3.*R(ii-1,jj)+Pold(ii,jj).*h0(ii,jj).^3.*R(ii,jj))./(24*mu*Rg*Temp*dr).*(Pold(ii,jj)-Pold(ii-1,jj));
    GS(ii,jj)=-(Pold(ii,jj).*h0(ii,jj).^3.*R(ii,jj)+Pold(ii+1,jj).*h0(ii+1,jj).^3.*R(ii+1,jj))./(24*mu*Rg*Temp*dr).*(Pold(ii+1,jj)-Pold(ii,jj));
    %Calcolo portata circonferenziale
    gO(ii,jj)=-(Pold(ii,jj-1).*h0(ii,jj-1).^3+Pold(ii,jj).*h0(ii,jj).^3)./(12*mu*Rg*Temp*(R(ii,jj-1)+R(ii,jj))).*(Pold(ii,jj)-Pold(ii,jj-1))/dtheta+omega.*(Pold(ii,jj-1).*h0(ii,jj-1).*R(ii,jj-1)+Pold(ii,jj).*h0(ii,jj).*R(ii,jj))/(4*Rg*Temp);
    gE(ii,jj)=-(Pold(ii,jj).*h0(ii,jj).^3+Pold(ii,jj+1).*h0(ii,jj+1).^3)./(12*mu*Rg*Temp*(R(ii,jj)+R(ii,jj+1))).*(Pold(ii,jj+1)-Pold(ii,jj))/dtheta+omega.*(Pold(ii,jj).*h0(ii,jj).*R(ii,jj)+Pold(ii,jj+1).*h0(ii,jj+1).*R(ii,jj+1))/(4*Rg*Temp);
    Gout(ii,jj)=((GS(ii,jj)-GN(ii,jj))*dtheta+(gE(ii,jj)-gO(ii,jj))*dr);%portante uscenti positive
    %Calcolo pressione meato da equazione di continuit
    Pnew(ii,jj)=Pold(ii,jj)+((Gi_new(ii,jj)-Gout(ii,jj))./(R(ii,jj)*dtheta*dr)-Pold(ii,jj).*h0_dot(ii,jj)./(Rg*Temp)).*(dt*Rg*Temp)./(h0(ii,jj)+ h_extra);

    %Calcolo errore
    err_P=abs(max((Pnew(:)-Pold(:))./Pold(:)));
    Err_P(iter)=err_P;
    %Diverge?
    if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
        fprintf('Iterations diverge\n');
        return;
    end
    %Equazioni relative al volume centrale
    Ac=(pi*R1^2)/(N-1); %Area di uno spicchio
    %Calcolo della portata normale (singoli spicchi)
    Gi_new(1,jj)=(ps^2-Pold(1,jj).^2).*(permeability*Ac)./(2*mu*Rg*Temp*L);
    %Calcolo portata radiale (singoli spicchi)
    GS(1,jj)=-(Pold(1,jj).*h0(1,jj).^3.*R(1,jj)+Pold(2,jj).*h0(2,jj).^3.*R(2,jj))./(24*mu*Rg*Temp*dr).*(Pold(2,jj)-Pold(1,jj));
    %Calcolo portata circonferenziale (singoli spicchi)
    gO(1,jj)=-(Pold(1,jj-1).*h0(1,jj-1).^3+Pold(1,jj).*h0(1,jj).^3)./(12*mu*Rg*Temp*(R(1,jj-1)+R(1,jj))).*(Pold(1,jj)-Pold(1,jj-1))/dtheta+omega.*(Pold(1,jj-1).*h0(1,jj-1).*R(1,jj-1)+Pold(1,jj).*h0(1,jj).*R(1,jj))/(4*Rg*Temp);
    gE(1,jj)=-(Pold(1,jj).*h0(1,jj).^3+Pold(1,jj+1).*h0(1,jj+1).^3)./(12*mu*Rg*Temp*(R(1,jj)+R(1,jj+1))).*(Pold(1,jj+1)-Pold(1,jj))/dtheta+omega.*(Pold(1,jj).*h0(1,jj).*R(1,jj)+Pold(1,jj+1).*h0(1,jj+1).*R(1,jj+1))/(4*Rg*Temp);
    Gout(1,jj)=(GS(1,jj)*dtheta+(gE(1,jj)-gO(1,jj))*dr);%portante uscenti positive
    %Equazione di continuit applicata al volume centrale (singoli spicchi)
    Pnew(1,jj)=Pold(1,jj)+((Gi_new(1,jj)-Gout(1,jj))-Pold(1,jj).*h0_dot(1,jj).*Ac./(Rg*Temp)).*(dt*Rg*Temp)./((h0(1,jj)+h_extra).*Ac);

    %Boundary conditions Periodicity
    Pnew(:,1)=Pnew(:,N+1);
    Pnew(:,N+2)=Pnew(:,2);

    % calcolo della capacit di carico
    Fc=sum(Pnew(1,jj)*Ac); %volume centrale
%      Fc=0;
    F1=sum((Pnew(ii,jj)-pa)*dr*dtheta.*R(ii,jj),'all')+Fc;
    err_F=(F1-F0)/F0;
    Err_F(iter)=err_F;
    %Calcolo della portata in ingresso
    G1in=sum(Gi_new(1:M-1,jj),'all');
    %Calcolo della portata in uscita O-N-E-S
    G1out=sum(Gout(1:M-1,jj),'all');
    err_G=(G1in-G1out)/G1in;
    Err_G(iter)=err_G; 
       
%         if contatore==no_punti
%         Time=[Time t];
%         Fpt=[Fpt F1];
%         Gint=[Gint G1in];
%         Goutt=[Goutt G1out];
%         Err_F=[Err_F err_F];
%         Err_G=[Err_G err_G];
%         Err_P=[Err_P err_P];
%            
%         contatore=0;             
%     end
    
    

    end
    toc
    Fp=F1;
    Qin=G1in*cG;
    Qout=G1out*cG;


    figure
%     plot(Err_P),hold on
    plot(Err_F,'ro'),hold on
    plot(Err_G,'b'),hold on
    xlabel('iterations'),ylabel('Error'),grid on  
    pause(0.5)


    figure
    surf(X(:,2:end)*1e3,Y(:,2:end)*1e3,Pnew(:,2:end)), hold on
    %    surf(0*1e3,0*1e3,mean(pc)), hold on
    xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
    pause(0.5)
    
%     save Statica
%% Parte dinamica
% clc
% clear all
% close all
% 
%     load Statica
    tic
    g=9.806;
    Fext=Fp;
    Freq1=[2, 4, 8, 10, 20, 30, 40, 50];
    Freq2=[50:10:200];
    Freq=[Freq1];
    %Condizioni Iniziali
    h1c_dot=0;
    h1c=H0*1e-6;
    h1=h0;
    h1_dot=ones(size(h0))*h1c_dot;
    

    iter=0;
    contatore=0;
    t=0;
    
    for indF=1:length(Freq)
    err_P=10;
    err_G=10;
    err_F=10;
    % m=Fext/g;
    % m=1;
     m=0.5;

    no_punti=3000;
    window=no_punti;

    while err_F>toll_F 
    iter=iter+1;
    t=t+dt;
    contatore=contatore+1;
    
    F0=F1;
    Pold=Pnew;
    h0c=h1c;
    h0c_dot=h1c_dot;
    h0=ones(size(h0))*h0c;
    h0_dot=ones(size(h0))*h0c_dot;

    jj=[2:N+1];   ii=[2:M-1]; %Nodi interni
    %Nodi interni
    %Calcolo portata in ingresso nodi
    Gi_new(ii,jj)=((ps^2-Pold(ii,jj).^2).*permeability.*R(ii,jj)*dr*dtheta)/(2*mu*Rg*Temp*L);
    %Calcolo portata radiale
    GN(ii,jj)=-(Pold(ii-1,jj).*h0(ii-1,jj).^3.*R(ii-1,jj)+Pold(ii,jj).*h0(ii,jj).^3.*R(ii,jj))./(24*mu*Rg*Temp*dr).*(Pold(ii,jj)-Pold(ii-1,jj));
    GS(ii,jj)=-(Pold(ii,jj).*h0(ii,jj).^3.*R(ii,jj)+Pold(ii+1,jj).*h0(ii+1,jj).^3.*R(ii+1,jj))./(24*mu*Rg*Temp*dr).*(Pold(ii+1,jj)-Pold(ii,jj));
    %Calcolo portata circonferenziale
    gO(ii,jj)=-(Pold(ii,jj-1).*h0(ii,jj-1).^3+Pold(ii,jj).*h0(ii,jj).^3)./(12*mu*Rg*Temp*(R(ii,jj-1)+R(ii,jj))).*(Pold(ii,jj)-Pold(ii,jj-1))/dtheta+omega.*(Pold(ii,jj-1).*h0(ii,jj-1).*R(ii,jj-1)+Pold(ii,jj).*h0(ii,jj).*R(ii,jj))/(4*Rg*Temp);
    gE(ii,jj)=-(Pold(ii,jj).*h0(ii,jj).^3+Pold(ii,jj+1).*h0(ii,jj+1).^3)./(12*mu*Rg*Temp*(R(ii,jj)+R(ii,jj+1))).*(Pold(ii,jj+1)-Pold(ii,jj))/dtheta+omega.*(Pold(ii,jj).*h0(ii,jj).*R(ii,jj)+Pold(ii,jj+1).*h0(ii,jj+1).*R(ii,jj+1))/(4*Rg*Temp);
    Gout(ii,jj)=((GS(ii,jj)-GN(ii,jj))*dtheta+(gE(ii,jj)-gO(ii,jj))*dr);%portante uscenti positive
    %Calcolo pressione meato da equazione di continuit
    Pnew(ii,jj)=Pold(ii,jj)+((Gi_new(ii,jj)-Gout(ii,jj))./(R(ii,jj)*dtheta*dr)-Pold(ii,jj).*h0_dot(ii,jj)./(Rg*Temp)).*(dt*Rg*Temp)./(h0(ii,jj)+ h_extra);

    %Calcolo errore
    err_P=abs(max((Pnew(:)-Pold(:))./Pold(:)));
    Err_P(iter)=err_P;
    %Diverge?
    if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
        fprintf('Iterations diverge\n');
        return;
    end
    %Equazioni relative al volume centrale
    Ac=(pi*R1^2)/(N-1); %Area di uno spicchio
    %Calcolo della portata normale (singoli spicchi)
    Gi_new(1,jj)=(ps^2-Pold(1,jj).^2).*(permeability*Ac)./(2*mu*Rg*Temp*L);
    %Calcolo portata radiale (singoli spicchi)
    GS(1,jj)=-(Pold(1,jj).*h0(1,jj).^3.*R(1,jj)+Pold(2,jj).*h0(2,jj).^3.*R(2,jj))./(24*mu*Rg*Temp*dr).*(Pold(2,jj)-Pold(1,jj));
    %Calcolo portata circonferenziale (singoli spicchi)
    gO(1,jj)=-(Pold(1,jj-1).*h0(1,jj-1).^3+Pold(1,jj).*h0(1,jj).^3)./(12*mu*Rg*Temp*(R(1,jj-1)+R(1,jj))).*(Pold(1,jj)-Pold(1,jj-1))/dtheta+omega.*(Pold(1,jj-1).*h0(1,jj-1).*R(1,jj-1)+Pold(1,jj).*h0(1,jj).*R(1,jj))/(4*Rg*Temp);
    gE(1,jj)=-(Pold(1,jj).*h0(1,jj).^3+Pold(1,jj+1).*h0(1,jj+1).^3)./(12*mu*Rg*Temp*(R(1,jj)+R(1,jj+1))).*(Pold(1,jj+1)-Pold(1,jj))/dtheta+omega.*(Pold(1,jj).*h0(1,jj).*R(1,jj)+Pold(1,jj+1).*h0(1,jj+1).*R(1,jj+1))/(4*Rg*Temp);
    Gout(1,jj)=(GS(1,jj)*dtheta+(gE(1,jj)-gO(1,jj))*dr);%portante uscenti positive
    %Equazione di continuit applicata al volume centrale (singoli spicchi)
    Pnew(1,jj)=Pold(1,jj)+((Gi_new(1,jj)-Gout(1,jj))-Pold(1,jj).*h0_dot(1,jj).*Ac./(Rg*Temp)).*(dt*Rg*Temp)./((h0(1,jj)+h_extra).*Ac);

    %Boundary conditions Periodicity
    Pnew(:,1)=Pnew(:,N+1);
    Pnew(:,N+2)=Pnew(:,2);

    % calcolo della capacit di carico
    Fc=sum(Pnew(1,jj)*Ac); %volume centrale
%      Fc=0;
    F1=sum((Pnew(ii,jj)-pa)*dr*dtheta.*R(ii,jj),'all')+Fc;
    err_F=(F1-Fext)/Fext;
    Err_F(iter)=err_F;
    %Calcolo della portata in ingresso
    G1in=sum(Gi_new(1:M-1,jj),'all');
    %Calcolo della portata in uscita O-N-E-S
    G1out=sum(Gout(1:M-1,jj),'all');
    err_G=(G1in-G1out)/G1in;
    Err_G(iter)=err_G; 
    
    
    h1c_dot=h0c_dot+(F1-Fext)*dt/m;
    h1c=h0c+h0c_dot*dt;
    
    h1=h1c*ones(size(Pold));
    h1_dot=h1c_dot*ones(size(Pold));

       
        if contatore==no_punti
        Time=[Time t];
        Fpt=[Fpt F1];
        Fet=[Fet Fext];
        Gint=[Gint G1in];
        Goutt=[Goutt G1out];
        H0t=[H0t h1c];
        H0_dott=[H0_dott h1c_dot];
        Err_F=[Err_F err_F];
        Err_G=[Err_G err_G];
        Err_P=[Err_P err_P];
                  
        contatore=0;             
        end   

    end
    
    %Parametri sinisioide
    freq=Freq(indF); %Hz
    w=2*pi*freq;
    DF=0.1*Fext;
    Periodo=1/freq;
    Cicli=5;
    fs=1/dt;
    Ns_dyn=Periodo*fs*(Cicli-1);
        t_dyn=0;
        
    for iter_din=1:Ns_dyn      
    iter=iter+1;
    t=t+dt;
    t_dyn=t_dyn+dt;
    contatore=contatore+1;
    
    F0=F1;
    Pold=Pnew;
    h0c=h1c;
    h0c_dot=h1c_dot;
    h0=ones(size(h0))*h0c;
    h0_dot=ones(size(h0))*h0c_dot;

    jj=[2:N+1];   ii=[2:M-1]; %Nodi interni
    %Nodi interni
    %Calcolo portata in ingresso nodi
    Gi_new(ii,jj)=((ps^2-Pold(ii,jj).^2).*permeability.*R(ii,jj)*dr*dtheta)/(2*mu*Rg*Temp*L);
    %Calcolo portata radiale
    GN(ii,jj)=-(Pold(ii-1,jj).*h0(ii-1,jj).^3.*R(ii-1,jj)+Pold(ii,jj).*h0(ii,jj).^3.*R(ii,jj))./(24*mu*Rg*Temp*dr).*(Pold(ii,jj)-Pold(ii-1,jj));
    GS(ii,jj)=-(Pold(ii,jj).*h0(ii,jj).^3.*R(ii,jj)+Pold(ii+1,jj).*h0(ii+1,jj).^3.*R(ii+1,jj))./(24*mu*Rg*Temp*dr).*(Pold(ii+1,jj)-Pold(ii,jj));
    %Calcolo portata circonferenziale
    gO(ii,jj)=-(Pold(ii,jj-1).*h0(ii,jj-1).^3+Pold(ii,jj).*h0(ii,jj).^3)./(12*mu*Rg*Temp*(R(ii,jj-1)+R(ii,jj))).*(Pold(ii,jj)-Pold(ii,jj-1))/dtheta+omega.*(Pold(ii,jj-1).*h0(ii,jj-1).*R(ii,jj-1)+Pold(ii,jj).*h0(ii,jj).*R(ii,jj))/(4*Rg*Temp);
    gE(ii,jj)=-(Pold(ii,jj).*h0(ii,jj).^3+Pold(ii,jj+1).*h0(ii,jj+1).^3)./(12*mu*Rg*Temp*(R(ii,jj)+R(ii,jj+1))).*(Pold(ii,jj+1)-Pold(ii,jj))/dtheta+omega.*(Pold(ii,jj).*h0(ii,jj).*R(ii,jj)+Pold(ii,jj+1).*h0(ii,jj+1).*R(ii,jj+1))/(4*Rg*Temp);
    Gout(ii,jj)=((GS(ii,jj)-GN(ii,jj))*dtheta+(gE(ii,jj)-gO(ii,jj))*dr);%portante uscenti positive
    %Calcolo pressione meato da equazione di continuit
    Pnew(ii,jj)=Pold(ii,jj)+((Gi_new(ii,jj)-Gout(ii,jj))./(R(ii,jj)*dtheta*dr)-Pold(ii,jj).*h0_dot(ii,jj)./(Rg*Temp)).*(dt*Rg*Temp)./(h0(ii,jj)+ h_extra);

    %Calcolo errore
    err_P=abs(max((Pnew(:)-Pold(:))./Pold(:)));
    Err_P(iter)=err_P;
    %Diverge?
    if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
        fprintf('Iterations diverge\n');
        return;
    end
    %Equazioni relative al volume centrale
    Ac=(pi*R1^2)/(N-1); %Area di uno spicchio
    %Calcolo della portata normale (singoli spicchi)
    Gi_new(1,jj)=(ps^2-Pold(1,jj).^2).*(permeability*Ac)./(2*mu*Rg*Temp*L);
    %Calcolo portata radiale (singoli spicchi)
    GS(1,jj)=-(Pold(1,jj).*h0(1,jj).^3.*R(1,jj)+Pold(2,jj).*h0(2,jj).^3.*R(2,jj))./(24*mu*Rg*Temp*dr).*(Pold(2,jj)-Pold(1,jj));
    %Calcolo portata circonferenziale (singoli spicchi)
    gO(1,jj)=-(Pold(1,jj-1).*h0(1,jj-1).^3+Pold(1,jj).*h0(1,jj).^3)./(12*mu*Rg*Temp*(R(1,jj-1)+R(1,jj))).*(Pold(1,jj)-Pold(1,jj-1))/dtheta+omega.*(Pold(1,jj-1).*h0(1,jj-1).*R(1,jj-1)+Pold(1,jj).*h0(1,jj).*R(1,jj))/(4*Rg*Temp);
    gE(1,jj)=-(Pold(1,jj).*h0(1,jj).^3+Pold(1,jj+1).*h0(1,jj+1).^3)./(12*mu*Rg*Temp*(R(1,jj)+R(1,jj+1))).*(Pold(1,jj+1)-Pold(1,jj))/dtheta+omega.*(Pold(1,jj).*h0(1,jj).*R(1,jj)+Pold(1,jj+1).*h0(1,jj+1).*R(1,jj+1))/(4*Rg*Temp);
    Gout(1,jj)=(GS(1,jj)*dtheta+(gE(1,jj)-gO(1,jj))*dr);%portante uscenti positive
    %Equazione di continuit applicata al volume centrale (singoli spicchi)
    Pnew(1,jj)=Pold(1,jj)+((Gi_new(1,jj)-Gout(1,jj))-Pold(1,jj).*h0_dot(1,jj).*Ac./(Rg*Temp)).*(dt*Rg*Temp)./((h0(1,jj)+h_extra).*Ac);

    %Boundary conditions Periodicity
    Pnew(:,1)=Pnew(:,N+1);
    Pnew(:,N+2)=Pnew(:,2);

    % calcolo della capacit di carico
    Fc=sum(Pnew(1,jj)*Ac); %volume centrale
%      Fc=0;
    F1=sum((Pnew(ii,jj)-pa)*dr*dtheta.*R(ii,jj),'all')+Fc;
    err_F=(F1-Fext)/Fext;
    Err_F(iter)=err_F;
    %Calcolo della portata in ingresso
    G1in=sum(Gi_new(1:M-1,jj),'all');
    %Calcolo della portata in uscita O-N-E-S
    G1out=sum(Gout(1:M-1,jj),'all');
    err_G=(G1in-G1out)/G1in;
    Err_G(iter)=err_G; 
    
    f_dyn=Fext+DF*sin(w*t_dyn);
    h1c_dot=h0c_dot+(F1-f_dyn)*dt/m;
    h1c=h0c+h0c_dot*dt;
    
    h1=h1c*ones(size(Pold));
    h1_dot=h1c_dot*ones(size(Pold));

       
        if contatore==no_punti
        Time=[Time t];
        Fpt=[Fpt F1];
        Fet=[Fet f_dyn];
        Gint=[Gint G1in];
        Goutt=[Goutt G1out];
        H0t=[H0t h1c];
        H0_dott=[H0_dott h1c_dot];
%         Err_F=[Err_F err_F];
%         Err_G=[Err_G err_G];
%         Err_P=[Err_P err_P];
       
        contatore=0;             
        end   

    end

    toc
    Fp(indF)=F1;
    Qin(indF)=G1in*cG;
    Qout(indF)=G1out*cG;
    H0(indF)=h0c*1e6;
    %% Calcolo Rigidezza e smorzamento
    FeFFT=Fet(end-floor(Ns_dyn/no_punti)+1:end)-mean(Fet(end-floor(Ns_dyn/no_punti)+1:end));
    hFFT=H0t(end-floor(Ns_dyn/no_punti)+1:end)-mean(H0t(end-floor(Ns_dyn/no_punti)+1:end));
    NFFT=length(FeFFT);
    Ph=fft(hFFT)/NFFT;
    PF=fft(FeFFT)/NFFT;
    df=fs/NFFT/no_punti;
    fFFT=df*[0:floor(NFFT/2)-1];
    Ingresso=2*(PF(1:floor(NFFT/2)));
    Uscita=2*(Ph(1:floor(NFFT/2)));
    [valh,indh]=max(abs(Uscita));
    [valF,indFe]=max(abs(Ingresso));
    Amp1=abs(Ingresso(indFe));
    Amp2=abs(Uscita(indh));
    phi1=atan2(imag(Ingresso(indFe)),real(Ingresso(indFe))); %phase information
    phi2=atan2(imag(Uscita(indh)),real(Uscita(indh))); %phase information
    Phi=(phi1-phi2);
    kdyn(indF)=-(Amp1/Amp2*cos(Phi))+m*w^2;
    damp(indF)=-(Amp1/Amp2*sin(Phi))/(w);


    figure
    plot(fFFT,Ingresso,'b','linewidth',linea),hold on
    plot(fFFT(indFe),Ingresso(indFe),'b*','linewidth',linea),hold on
    plot(fFFT,Uscita,'r','linewidth',linea),hold on
    plot(fFFT(indFe),Uscita(indFe),'r*','linewidth',linea),hold on
    xlabel('Frequency (s)'),ylabel('Amplitude'),grid on  
    xlim([0 200])
    pause(0.5)
    
    
    figure
    plot(Time,Fpt,'b','linewidth',linea),hold on
    plot(Time,Fet,'r','linewidth',linea),hold on
    xlabel('Time (s)'),ylabel('Force'),grid on  
    pause(0.5)
     
    % Creazione del primo asse Y
    figure;
    yyaxis left % Seleziona l'asse sinistro
    plot(Time, (H0t)*1e6, '-b', 'LineWidth', 2); 
    xlabel('Time (s)'),ylabel('Air Gap h($\mu m$)')
    grid on;
    % Creazione del secondo asse Y
    yyaxis right % Seleziona l'asse destro
    plot(Time,(Fet), '--r', 'LineWidth', 2); 
    xlabel('Time (s)'),ylabel('Force F (N)'),grid on
    % Titolo e legenda
    title('Grafico con doppio asse Y');
    legend('h(t)', 'F(t)', 'Location', 'northeast');
    pause(0.5)

    
    figure
    surf(X(:,2:end)*1e3,Y(:,2:end)*1e3,Pnew(:,2:end)), hold on
    xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
    pause(0.5)


    end

%% 
Test=1;
p_rel=(ps*1e-5)-1; %bar
shift=2;
Carico=[88 110 175 230 305];
Meato =[139 126 96 80 61];
for ind=1:length(Carico)
Caricamento=['load NW_D65_ps' num2str(p_rel*100) '_F' num2str(Carico(ind))  '_h' num2str(Meato(ind)) '_' num2str(Test)];
eval(Caricamento)
end


%Rigidezza dinamica
figure  
hold on
Rigidezza_1 = ['plot(f_ps' num2str(p_rel*100) '_F' num2str(Carico(1)) '_h' num2str(Meato(1)) '_' num2str(Test) ', k_ps' num2str(p_rel*100) '_F' num2str(Carico(1)) '_h' num2str(Meato(1)) '_' num2str(Test) ', ''o'', ''MarkerFaceColor'', ''none'', ''MarkerEdgeColor'', ''b'')'];
eval(Rigidezza_1)
Rigidezza_2 = ['plot(f_ps' num2str(p_rel*100) '_F' num2str(Carico(2)) '_h' num2str(Meato(2)) '_' num2str(Test) ', k_ps' num2str(p_rel*100) '_F' num2str(Carico(2)) '_h' num2str(Meato(2)) '_' num2str(Test) ', ''o'', ''MarkerFaceColor'', ''none'', ''MarkerEdgeColor'', ''r'')'];
eval(Rigidezza_2)
Rigidezza_3 = ['plot(f_ps' num2str(p_rel*100) '_F' num2str(Carico(3)) '_h' num2str(Meato(3)) '_' num2str(Test) ', k_ps' num2str(p_rel*100) '_F' num2str(Carico(3)) '_h' num2str(Meato(3)) '_' num2str(Test) ', ''o'', ''MarkerFaceColor'', ''none'', ''MarkerEdgeColor'', ''g'')'];
eval(Rigidezza_3)
Rigidezza_4 = ['plot(f_ps' num2str(p_rel*100) '_F' num2str(Carico(4)) '_h' num2str(Meato(4)) '_' num2str(Test) ', k_ps' num2str(p_rel*100) '_F' num2str(Carico(4)) '_h' num2str(Meato(4)) '_' num2str(Test) ', ''o'', ''MarkerFaceColor'', ''none'', ''MarkerEdgeColor'', ''k'')'];
eval(Rigidezza_4)
Rigidezza_5 = ['plot(f_ps' num2str(p_rel*100) '_F' num2str(Carico(5)) '_h' num2str(Meato(5)) '_' num2str(Test) ', k_ps' num2str(p_rel*100) '_F' num2str(Carico(5)) '_h' num2str(Meato(5)) '_' num2str(Test) ', ''o'', ''MarkerFaceColor'', ''none'', ''MarkerEdgeColor'', ''m'')'];
eval(Rigidezza_5)
 plot(Freq,(kdyn*1e-6),'b','linewidth',linea),hold on
 % legend( ['Experimental F= ' num2str(Carico(1)) ' N'],['Experimental F= ' num2str(Carico(2)) ' N'],[ 'Experimental F= ' num2str(Carico(3)) ' N'],['Experimental F= ' num2str(Carico(4)) ' N'],['Experimental F= ' num2str(Carico(5)) ' N'],'Numerical')
% legend('Experimental','Numerical')   
xlabel('Frequency $f$(Hz)'),ylabel('Stiffness $k$ ($\frac{N}{\mu m}$)')
grid on, zoom on
% xlim([fmin fmax])
xlim([0 max(Freq)+5])


%Smorzamento
figure  
hold on 
Smorzamento_1 = ['plot(f_ps' num2str(p_rel*100) '_F' num2str(Carico(1)) '_h' num2str(Meato(1)) '_' num2str(Test) ', c_ps' num2str(p_rel*100) '_F' num2str(Carico(1)) '_h' num2str(Meato(1)) '_' num2str(Test) ', ''o'', ''MarkerFaceColor'', ''none'', ''MarkerEdgeColor'', ''b'')'];
eval(Smorzamento_1)
Smorzamento_2 = ['plot(f_ps' num2str(p_rel*100) '_F' num2str(Carico(2)) '_h' num2str(Meato(2)) '_' num2str(Test) ', c_ps' num2str(p_rel*100) '_F' num2str(Carico(2)) '_h' num2str(Meato(2)) '_' num2str(Test) ', ''o'', ''MarkerFaceColor'', ''none'', ''MarkerEdgeColor'', ''r'')'];
eval(Smorzamento_2)
Smorzamento_3 = ['plot(f_ps' num2str(p_rel*100) '_F' num2str(Carico(3)) '_h' num2str(Meato(3)) '_' num2str(Test) ', c_ps' num2str(p_rel*100) '_F' num2str(Carico(3)) '_h' num2str(Meato(3)) '_' num2str(Test) ', ''o'', ''MarkerFaceColor'', ''none'', ''MarkerEdgeColor'', ''g'')'];
eval(Smorzamento_3)
Smorzamento_4 = ['plot(f_ps' num2str(p_rel*100) '_F' num2str(Carico(4)) '_h' num2str(Meato(4)) '_' num2str(Test) ', c_ps' num2str(p_rel*100) '_F' num2str(Carico(4)) '_h' num2str(Meato(4)) '_' num2str(Test) ', ''o'', ''MarkerFaceColor'', ''none'', ''MarkerEdgeColor'', ''k'')'];
eval(Smorzamento_4)
Smorzamento_5 = ['plot(f_ps' num2str(p_rel*100) '_F' num2str(Carico(5)) '_h' num2str(Meato(5)) '_' num2str(Test) ', c_ps' num2str(p_rel*100) '_F' num2str(Carico(5)) '_h' num2str(Meato(5)) '_' num2str(Test) ', ''o'', ''MarkerFaceColor'', ''none'', ''MarkerEdgeColor'', ''m'')'];
eval(Smorzamento_5)
plot(Freq,damp*1e-6,'b','linewidth',linea),hold on
% legend('Experimental','Numerical')   
xlabel('Frequency $f$($Hz$)'),ylabel('Damping $c$ ($\frac{Ns}{\mu m}$)')
grid on, zoom on
xlim([0 max(Freq)+5])


% meato=['h' num2str(p_rel*100) '=H0;'];
% Forza=['F' num2str(p_rel*100) '=Fp;'];
% Portata_in=['Qin' num2str(p_rel*100) '=Qin;'];
% Portata_out=['Qout' num2str(p_rel*100) '=Qout;'];
% stiffness=['ks' num2str(p_rel*100) '=ks;'];
% eval(meato)
% eval(Forza)
% eval(Portata_in)
% eval(Portata_out)
% eval(stiffness)
% 
% salva=['save Modello_Statico_NW_D65_ps' num2str(p_rel*100) ' h' num2str(p_rel*100) ' F' num2str(p_rel*100) ...
%         ' Qin' num2str(p_rel*100) ' Qout' num2str(p_rel*100)  ' ks' num2str(p_rel*100) ];
% 
%    eval(salva)

   